const AI_SEEK=0;const AI_STOPPING=1;const AI_IDLE=2;const AI_COMBAT=3;const AI_NOTHING=4;const AI_FLEE=5;const AI_LEAVE=6;const AI_JUMPING=7;const AI_PASSIVE=0;const AI_AGGRESSIVE=1;const AI_DEFENSIVE=2;function IncludeAI(ai_type){this.ai_status=AI_SEEK;this.aiTimer=0;this.radius=1000;this.isEnemy=true;this.aggressive=false;this.secondaryTimer=0;this.planet=null;this.ai_type=ai_type;this.ai=null;this.ai_on_hit=null;this.hasBounty=false;this.targetPoint=null;this.pointed=false;this.sight_a=new Angle();this.idle_msecs=0;this.sightTarget=SightTarget;this.moveToTarget=MoveToTarget;this.moveToPlanet=MoveToPlanet;this.avoidTarget=Avoid;this.moveRandomly=MoveRandomly;this.slowToStop=SlowToStop;switch(ai_type){case AI_PASSIVE:this.ai=PassiveAggressive;this.ai_on_hit=PassiveOnHit;break;case AI_AGGRESSIVE:this.ai=Aggressive;this.ai_on_hit=AggressiveOnHit;break;default:this.ai=PassiveAggressive;this.ai_on_hit=PassiveOnHit;break;}}
function Ship(ai_type){this.inherit=ShipEntity;this.inherit();this.inherit=IncludeAI;this.inherit(ai_type);this.id=0;this.text="";this.t_timer=0;this.hpval=new TimedValue(this.hp.value,500);this.setText=function(text){this.text=text;this.t_timer=GetTime();}
this.onHit=function(bullet){this.hpval.scale(this.hp.value);this.showHp();if(this.hp.value<=0){Audio.playSound(Resources.sounds.bigboom);if(this.hasBounty)
Genesis.player.updateBountyQuest(this.name);if(Genesis.player.target!=null&&this.id==Genesis.player.target.id){Genesis.player.target=null;}
Genesis.ships.splice(Utility.indexOf(Genesis.ships,this),1);ParticleEngine.explode(this.x,this.y,5,1000,2,CreateColor(255,255,255),Resources.images.steel);ParticleEngine.explode(this.x,this.y,10,1000,0.25,CreateColor(255,255,255),Resources.images.fire);return;}
if(this.ai_on_hit!=null)this.ai_on_hit(bullet);}
this.afterJump=function(){if(Genesis.player.target!=null&&this.id==Genesis.player.target.id){Genesis.player.target=null;}
Genesis.ships.splice(Utility.indexOf(Genesis.ships,this),1);}
this.hp_time=0;this.showHp=function(){this.hp_time=GetTime();}
this.drawHealth=function(){if(this.hp_time+1000>GetTime()){this.hpval.update();var x=this.xx+(this.w/2)-30;var y=this.yy-6;var w=(this.hpval.value/this.hp.max)*60;OutlinedRectangle(x,y,60,6,Colors.darkGray);Rectangle(x,y,w,6,Colors.green);}}
this.update=function(){this.draw();this.drawHealth();if(this.t_timer+2000>GetTime())
System.windowFont.drawText(this.xx+this.w/2-System.windowFont.getStringWidth(this.text)/2,this.yy-8,this.text);else
System.windowFont.drawText(this.xx+this.w/2-System.windowFont.getStringWidth(this.name)/2,this.yy-8,this.name);if(this.ai!=null)this.ai();}
this.checkMouse=function(){if(Cursor.isWithin(this.xx,this.yy,this.w,this.h)){Genesis.player.target=this;Cursor.leftClick=false;}}}
function CreateRandomShip(){var e=new Ship(AI_PASSIVE);e.setupShip(Ships[Utility.random(Ships.length-1)]);e.name=GenerateName(e.nameType);return e;}
function CreateBountyShip(quest){var e=new Ship(AI_AGGRESSIVE);if(quest.reward>2000)e.setupShip(Ships[5]);else if(quest.reward>1000)e.setupShip(Ships[4]);else if(quest.reward>500)e.setupShip(Ships[1]);else e.setupShip(Ships[0]);e.image="e_"+e.image;e.name=quest.shipname;e.hasBounty=true;return e;}
function SightTarget()
{if(this.target==null)return false;var dx=this.x-this.target.x;var dy=this.y-this.target.y;var dist=Math.sqrt(dx*dx,dy*dy);if(dist<=this.radius){this.sight_a.radians=Math.atan2(dy,dx)-A_PI;return(this.sight_a.degrees>this.a.degrees-23&&this.sight_a.degrees<this.a.degrees+23);}
else return false;}
function MoveToTarget()
{if(this.target==null)return;this.target_a.radians=Math.atan2(this.y-this.target.y,this.x-this.target.x)-A_PI;this.turnToTarget();this.updateVelocity();return(this.target.x>this.cx-8&&this.target.y>this.cy-8&&this.target.x<this.cx+8&&this.target.y<this.cy+8);}
function MoveRandomly()
{if(this.target==null){this.target={x:-1000+Utility.random(2000),y:-1000+Utility.random(2000)}}
if(this.moveToTarget()){this.target={x:-1000+Utility.random(2000),y:-1000+Utility.random(2000)}}}
function MoveToPlanet()
{if(this.planet==null){var planets=GameWorlds[Genesis.currentWorld].planets;this.planet=Planets[planets[Math.floor(Math.random()*planets.length)]];}
var dx=this.x-this.planet.x-this.planet.w/2;var dy=this.y-this.planet.y-this.planet.h/2;this.target_a.radians=Math.atan2(dy,dx)-A_PI;this.turnToTarget();this.updateVelocity();var x=this.planet.x-Math.cos(this.a.radians)*100*this.speed;var y=this.planet.y-Math.sin(this.a.radians)*100*this.speed;return(this.x>x&&this.y>y&&this.x<x+this.planet.w&&this.y<y+this.planet.h);}
function SlowToStop(){if(!this.pointed){this.target_a.degrees=this.a.degrees-180;this.pointed=true;}
if(this.turnToTarget()){this.updateVelocity();if(Math.floor(this.speed+0.25)==0){this.vx=0;this.vy=0;this.resetThrust();this.pointed=false;return true;}}
return false;}
function Avoid()
{if(this.target==null)return;var dx=this.x-this.target.x;var dy=this.y-this.target.y;this.target_a.radians=Math.atan2(dx,dy);this.turnToTarget();this.updateVelocity();}
function PassiveOnHit(bullet){if(!this.aggressive){if(this.hp.value<=this.hp.max*.80){this.aggressive=true;this.ai_status=AI_COMBAT;this.setText(TextGen.getAttackText());this.target=bullet.parent;this.maxspeed=this.lastspeed;this.a_msecs=this.last_a_msecs;this.secondaryTimer=GetTime();Audio.playSound(Resources.sounds.alert);Genesis.player.updateEscortQuests(HATES_COMBAT);}
else this.setText(TextGen.getHurtText());}
if(!this.fled&&this.hp.value<=this.hp.max*0.20){this.ai_status=AI_FLEE;this.setText(TextGen.getFleeText());this.stopTimer=GetTime();this.fled=true;this.aggressive=false;}}
function PassiveAggressive()
{switch(this.ai_status){case AI_SEEK:if(this.moveToPlanet())this.ai_status=AI_STOPPING;break;case AI_IDLE:if(this.stopTimer+this.idle_msecs<GetTime()){if(GameWorlds[Genesis.currentWorld].planets.length>1&&Utility.random(9)>=5){this.planet=null;this.ai_status=AI_SEEK;}
else this.ai_status=AI_LEAVE;}
break;case AI_COMBAT:this.moveToTarget();if(this.sightTarget()){if(this.aiTimer+1000<GetTime()){this.firePrimary();this.aiTimer=GetTime();}
if(this.secondaryTimer+6000<GetTime()){this.fireSecondary();this.secondaryTimer=GetTime();}}
break;case AI_STOPPING:if(this.slowToStop()){this.stopTimer=GetTime();this.idle_msecs=15000+Utility.random(10000);this.ai_status=AI_IDLE;}
break;case AI_FLEE:this.avoidTarget();if(this.stopTimer+15000<GetTime()){this.ai_status=AI_LEAVE;}
break;case AI_LEAVE:var loc=StarChart.getRandomPlanet();this.hyperJump(GameWorlds[loc.system].origin);this.setText("Goodbye!");this.ai_status=AI_JUMPING;break;case AI_JUMPING:this.doJump();break;}}
function AggressiveOnHit(bullet){if(!this.aggressive){this.aggressive=true;this.ai_status=AI_COMBAT;this.secondaryTimer=GetTime();this.setText("I'm going to kill you!");this.target=bullet.parent;this.maxspeed=this.lastspeed;Audio.playSound(Resources.sounds.alert);Genesis.player.updateEscortQuests(HATES_COMBAT);}}
function Aggressive()
{switch(this.ai_status){case AI_COMBAT:this.moveToTarget();if(this.sightTarget()){if(this.aiTimer+500<GetTime()){this.firePrimary();this.aiTimer=GetTime();}}
if(this.secondaryTimer+4000<GetTime()){this.setText("Eat this, asshole.");this.fireSecondary();this.secondaryTimer=GetTime();}
break;case AI_SEEK:this.moveRandomly();if(this.sightTarget()&&this.aggressive){this.ai_status=AI_COMBAT;}
break;}}